package com.agilex.healthcare.directscheduling.datalayer;

import com.agilex.healthcare.directscheduling.domain.AppointmentSlotFilter;
import com.agilex.healthcare.directscheduling.domain.AppointmentTimeSlots;
import com.agilex.healthcare.directscheduling.domain.BookAppointment;
import com.agilex.healthcare.directscheduling.domain.BookedAppointments;
import com.agilex.healthcare.directscheduling.domain.CancelAppointment;
import com.agilex.healthcare.directscheduling.domain.CancelReasons;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;

public interface SchedulingDataLayer {
	BookAppointment bookPatientAppointment(BookAppointment bookAppointment, String siteCode);
	BookedAppointments getPatientBookedAppointments(AppointmentSlotFilter appointmentSlotFilter);
	CancelAppointment cancelAppointmentForPatient(CancelAppointment cancelAppointmentObject, String siteCode);
	AppointmentTimeSlots getClinicSchedulingDetail(AppointmentSlotFilter appointmentSlotFilter);
	CancelReasons getCancelReasonList(PatientIdentifier patientIdentifier, String facilityCode);
}